function JChart(owner, parent, name, dataset, rect, tab)
{
	var self = this,
		_disposed = false,
		_dummy = 0,
		_afm;

	this.initialize (owner, parent, name, null, null, rect, null, null, dataset, tab);

	this.methods = (cmRender | cmLoad);

	this.render  = render;
	this.load    = load;
	this.dispose = dispose;

	_afm = self.getForm().name; 

	function render(fs)
	{
//		fs.append('<div class="imageBox" id="' + self.name + '_box" style="' + self.rect + '; overflow:auto">');
		fs.append('<div class="imageBox" id="' + self.name + '_box" style="overflow:auto">');
		fs.append('<img class="image" id="' + self.name + '" src="" style="display:none" />');
		fs.append('</div>');
		fs.append('<div id="' + self.name + '_nav" style="position: absolute;">');
		fs.append('<div id="' + self.name + '_loadMsg" style="padding-bottom: 3;">Loading...</div>');
		fs.append('</div>');
	}

	function load()
	{
		_position = self.checkPosition();

		var box = self.$$('_box');
		var style = box.style;
		if (_position.isRightMost)
		{
			var pw = box.parentNode.clientWidth;
			if (pw == 0)
				pw = self.$(self.parent).clientWidth;

			self.rect.width = pw - self.rect.left - 8; 
			style.width = self.rect.width;
		}

		if (_position.isBottomMost)
		{
			var ph = box.parentNode.clientHeight;
			if (ph == 0)
				ph = self.$(self.parent).clientHeight;

			self.rect.height = ph - self.rect.top - 8; 
			style.height = self.rect.height;
		}

		setSrc();

		if (self.dataset != null)
			self.dataset.onrecordchanged.attach(setSrc);
	}

	function setSrc()
	{
		_dummy++;
		var src = self.owner.cgiPath();
		if (self.owner.isPortalVersion())
			src += '&';
		else
			src += '?';

		src += 'act=getChart&cid=' + self.owner.session + '&afm=' + _afm +
			'&obj=' + self.name + '&dummy=' + _dummy;

		self.$$('_loadMsg').style.visibility = 'inherit';
		self.$$().src = src;
		self.$$().onload = function()
			{
				this.style.display = 'inline';
				this.onload = null;
				self.$$('_loadMsg').style.visibility = 'hidden';
			}
	}

	function dispose()
	{
		if ((dataset != null) && (dataset.onrecordchanged != null))
			dataset.onrecordchanged.detach(setSrc);
	}
}

JChart.inheritsFrom(ControlBase);

if (typeof(loadNextScript) != 'undefined')
	loadNextScript();